#include <iostream>
#include <vector>
#include <algorithm>

using namespace std;

int main() {
    int N;
    vector<int> A(N), B(N);

    for (int i = 0; i < N; i++) {
        cin >> A[i];
    }
    for (int i = 0; i < N; i++) {
        cin >> B[i];
    }
    
    const int xorIdentity = 0; // 0 ^ 1 = 1    0 ^ 0 = 0
    const int andIdentity = -1; // 1*32 in binary
    int maxValue = 0;
    
    // O(n^2)
    for (int L = 0; L < N; L++) {
        int xorValue = xorIdentity;
        int andValue = andIdentity;
        for (int R = L; R < N; R++) {
            xorValue ^= A[R];
            andValue &= B[R];

            maxValue = max(maxValue, xorValue * andValue);
        }       
    }

    cout << maxValue;
    return 0;
}